import os
import re
import string

pattern = re.compile("^[A-Za-z_][A-Za-z0-9_.]*$")

def hgmanifest(srcdir):
    return getContentsDict(srcdir)

def getContentsDict(path):
    if(not os.path.isdir(path)):
        return None
    # if path is dir
    results = os.listdir(path)
    contentsDict = {}
    for r in results:
        if(not os.path.isdir(path+os.sep+r)):
            if(name_check(r) is not None):
                contentsDict[r] = None
        else:
            contentsDict[r] = getContentsDict(path+os.sep+r)
    return contentsDict

def getCurrentLevelName(path):
    '''
    ./a/b/c return c
    or ./a/b/c/ return c
    '''
    if(path[-1] == os.sep):
        lastSep = path[:-1].rfind(os.sep)
        return path[lastSep+1:-1]
    else:
        lastSep = path.rfind(os.sep)
        return path[lastSep+1:]

def name_check(name):
    name = name.replace(" ", "_")
    name = name.replace("-", "_")
    name = name.replace("+", "_")
    if name[0] in string.digits:
        name = "_"+name
    return pattern.match(name)
